# gof_peas.R
# Goodness-of-fit test for Mendel data

# Load necessary libraries
library(DescTools)

# Data values
obsfreq <- c(315,101,108,32)

# Probabilities and expected frequencies under H0
p0 <- c(0.5625,0.1875,0.1875,0.0625)
expfreq <- sum(obsfreq)*p0

# Observed and expected frequencies
rbind(obsfreq,expfreq)

# X2 Goodness-of-fit test
# Asymptotic test
chisq.test(obsfreq,p=p0)

# X2 exact test using simulation
chisq.test(obsfreq,p=p0,simulate.p.value=TRUE)

# G2 goodness-of-fit test
GTest(obsfreq,p=p0)    
